/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.util.ChunkCapData;
import com.minecolonies.coremod.util.ChunkClientDataHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateChunkRangeCapabilityMessage
implements IMessage {
    private final List<ChunkCapData> caps = new ArrayList<ChunkCapData>();

    public UpdateChunkRangeCapabilityMessage() {
    }

    public UpdateChunkRangeCapabilityMessage(@NotNull World world, int xC, int zC, int range, boolean checkLoaded) {
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                Chunk chunk;
                IColonyTagCapability cap;
                int chunkX = xC + x;
                int chunkZ = zC + z;
                if (checkLoaded && !WorldUtil.isEntityChunkLoaded((IWorld)world, chunkX, chunkZ) || (cap = (IColonyTagCapability)(chunk = world.func_212866_a_(chunkX, chunkZ)).getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null)) == null) continue;
                this.caps.add(new ChunkCapData(chunkX, chunkZ, cap.getOwningColony(), cap.getStaticClaimColonies()));
            }
        }
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.caps.add(ChunkCapData.fromBytes(buf));
        }
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeInt(this.caps.size());
        for (ChunkCapData c : this.caps) {
            c.toBytes(buf);
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        for (ChunkCapData data : this.caps) {
            if (!WorldUtil.isChunkLoaded((IWorld)world, new ChunkPos(data.x, data.z))) {
                ChunkClientDataHelper.addCapData(data);
                continue;
            }
            Chunk chunk = world.func_212866_a_(data.x, data.z);
            ChunkClientDataHelper.applyCap(data, chunk);
        }
    }
}

